/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PROD_TRIB]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_EMB_APRES]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [dbo].[UFD_EST_PROD_EMB_APRES]
GO 

CREATE FUNCTION dbo.UFD_EST_PROD_EMB_APRES(@CD_EMP INT, @CD_PROD INT, @CD_FORN INT) 

RETURNS @RsProd  TABLE ( CD_PROD INT, 
						CD_FORN		INT,
						QT_EMB_COMPRA	MONEY,
						QT_EMB_VENDA	MONEY,
						QT_EMB_RESSUP	MONEY,
						FLAG_NAO_CONVERTER_EMBALAGEM INT,
						DS_UN			VARCHAR(10),
						APRES_EMB_CP	MONEY,
						APRES_QT_CP		MONEY)
 
WITH ENCRYPTION AS 
BEGIN  

	INSERT INTO 
		@RsProd
	SELECT
		P.CD_PROD,
		@CD_FORN CD_FORN,
		(F.APRES_QT_CP * F.APRES_EMB_CP) QT_EMB_COMPRA,
		CONVERT(MONEY,REPLACE(p.APRES_EMB_VD,',','.')) *  CONVERT(MONEY,REPLACE(p.APRES_QT_VD,',','.'))  QT_EMB_VENDA,
		(P.QT_UNI_RESSUPRIMENTO) QT_EMB_RESSUP,
		ISNULL(N.FLAG_NAO_CONVERTER_EMBALAGEM,0) AS FLAG_NAO_CONVERTER_EMBALAGEM,
		coalesce(u.DS_UN,'UN') DS_UN,
		F.APRES_EMB_CP APRES_EMB_CP,
		F.APRES_QT_CP APRES_QT_CP

	FROM 
		EST_PROD P
		INNER JOIN EST_PROD_FORN F  ON 
			P.CD_EMP = F.CD_EMP AND
			P.CD_PROD = F.CD_PROD
		INNER JOIN PG_FORN N  ON 
			F.CD_EMP = N.CD_EMP AND
			F.CD_FORN = N.CD_FORN
		LEFT JOIN EST_PROD_UN_MED U ON 
			P.CD_UN_CP = u.CD_CTR_UN
	WHERE
		P.CD_EMP = @CD_EMP
		AND P.CD_PROD = @CD_PROD
		AND F.CD_FORN=@CD_FORN

	IF @@ROWCOUNT = 0 BEGIN
		INSERT INTO 
			@RsProd
		SELECT  
			CD_PROD,
			@CD_FORN CD_FORN,
			CONVERT(MONEY,REPLACE(p.APRES_EMB_CP,',','.')) *  CONVERT(MONEY,REPLACE(p.APRES_QT_CP,',','.'))  QT_EMB_COMPRA,
			CONVERT(MONEY,REPLACE(p.APRES_EMB_VD,',','.')) *  CONVERT(MONEY,REPLACE(p.APRES_QT_VD,',','.'))  QT_EMB_VENDA,
			(QT_UNI_RESSUPRIMENTO) QT_EMB_RESSUP,
			0 FLAG_NAO_CONVERTER_EMBALAGEM,
			coalesce(u.DS_UN,'UN') DS_UN,
			P.APRES_EMB_CP APRES_EMB_CP,
			P.APRES_QT_CP APRES_QT_CP
		FROM 
			EST_PROD p			
			LEFT JOIN EST_PROD_UN_MED U ON 
			P.CD_UN_CP = u.CD_CTR_UN

		WHERE
			p.CD_EMP = @CD_EMP
			AND p.CD_PROD = @CD_PROD
	END
	RETURN 
END